<?php
    require_once __DIR__ . '/../vendor/PHPMailer/src/Exception.php';
    require_once __DIR__ . '/../vendor/PHPMailer/src/PHPMailer.php';
    require_once __DIR__ . '/../vendor/PHPMailer/src/SMTP.php';

    require_once __DIR__ . '/../config/mail.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;

    class Mailer {
        private $mail;

        
        public function __construct() {
            $this->mail = new PHPMailer(true); // true enables exceptions
            try {
                $this->mail->isSMTP();                             // Send using SMTP
                $this->mail->Host       = MAIL_HOST;               // Set the SMTP server to send through
                $this->mail->SMTPAuth   = true;                    // Enable SMTP authentication
                $this->mail->Username   = MAIL_USERNAME;           // SMTP username
                $this->mail->Password   = MAIL_PASSWORD;           // SMTP password
                $this->mail->SMTPSecure = MAIL_ENCRYPTION;         // Enable implicit TLS encryption (or 'ssl')
                $this->mail->Port       = MAIL_PORT;               // TCP port to connect to

                $this->mail->setFrom(MAIL_FROM_EMAIL, MAIL_FROM_NAME); // Set sender email and name
                $this->mail->isHTML(true);                         // Set email format to HTML
                $this->mail->CharSet = 'UTF-8';                    // Set character set for proper encoding

            } catch (Exception $e) {
                error_log("Mailer configuration error: " . $e->getMessage());
            
            }
        }


        public function sendMail($toEmail, $toName, $subject, $body, $attachmentPath = '', $altBody = '') {
            try {
                $this->mail->clearAddresses();    // Clear all addresses and attachments for fresh send
                $this->mail->clearAttachments();
                $this->mail->addAddress($toEmail, $toName); // Add a recipient
                $this->mail->Subject = $subject;
                $this->mail->Body    = $body;
                $this->mail->AltBody = $altBody ?: strip_tags($body); // Generate alt body if not provided

                if (!empty($attachmentPath) && file_exists($attachmentPath)) {
                    $this->mail->addAttachment($attachmentPath); // Add attachment
                }

                return $this->mail->send();
            } catch (Exception $e) {
                error_log("Email sending failed to $toEmail: " . $this->mail->ErrorInfo);
                return false;
            }
        }

    
        public function getEmailTemplate($templateName, $data = []) {
            
            ob_start();
        
            $templatePath = __DIR__ . "/../templates/{$templateName}.html";

            if (!file_exists($templatePath)) {
                error_log("Email template not found: " . $templatePath);
                return "Template not found: {$templateName}"; // Return an error message or empty string
            }

        
            extract($data);

            include $templatePath;
        
            return ob_get_clean();
        }
    }
?>
