<?php

    require_once __DIR__ . '/../vendor/firebase/php-jwt/src/JWT.php';
    define('JWT_SECRET_KEY', 'R3hlkoiZK0hlerByR0y@lM3vAn');

    function generateJwt($userId, $role, $email, $fullname) {
        $issuedAt = time();
        $expirationTime = $issuedAt + (60 * 60 * 24 *30 ); 
        $issuer = APP_BASE_URL; 

        $payload = [
            'iat' => $issuedAt,             // Issued at: time when the token was generated
            'exp' => $expirationTime,       // Expiration time: time when the token expires
            'iss' => $issuer,               // Issuer: who created the token
            'aud' => 'RehlkoCustomerCare',  // Audience: who the token is intended for
            'userId' => $userId,            // Custom data: User ID
            'role' => $role,                // Custom data: User Role
            'email' => $email,              // Custom data: User Email
            'fullname' => $fullname         // Custom data: User Full Name
        ];

    
        $header = base64_encode(json_encode(['alg' => 'HS256', 'typ' => 'JWT']));
        $payload_encoded = base64_encode(json_encode($payload));
        $signature = hash_hmac('sha256', "$header.$payload_encoded", JWT_SECRET_KEY, true);
        $signature_encoded = base64_encode($signature);

        return "$header.$payload_encoded.$signature_encoded";

    }

    function validateJwt($token) {
        if (empty($token) || !str_starts_with($token, 'Bearer ')) {
            return false;
        }

        $token = substr($token, 7); 

        
        try {
            list($header_encoded, $payload_encoded, $signature_encoded) = explode('.', $token);

            $payload = json_decode(base64_decode($payload_encoded), true);
            $header = json_decode(base64_decode($header_encoded), true);

    
            $expected_signature = hash_hmac('sha256', "$header_encoded.$payload_encoded", JWT_SECRET_KEY, true);
            $expected_signature_encoded = base64_encode($expected_signature);

            if ($expected_signature_encoded !== $signature_encoded) {
                error_log("JWT Validation Error: Signature mismatch.");
                return false;
            }
    
            if (!isset($payload['exp']) || $payload['exp'] < time()) {
                error_log("JWT Validation Error: Token expired.");
                return false;
            }

            return $payload;

        } catch (Exception $e) {
            error_log("JWT Validation Error: " . $e->getMessage());
            return false;
        }
    }
    
    function hashPassword($password) {
        return password_hash($password, PASSWORD_BCRYPT);
    }


    function verifyPassword($password, $hash) {
        return password_verify($password, $hash);
    }


    function sendJsonResponse($data, $statusCode = 200) {
        http_response_code($statusCode);
        header('Content-Type: application/json');
        echo json_encode($data);
        exit(); 
    }


    function generateUniqueIndex($prefix) {
        return $prefix . date('YmdHis') . uniqid();
    }


    function getCurrentUserRole() {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? '';
        $jwtPayload = validateJwt($authHeader);

        if ($jwtPayload && isset($jwtPayload['role'])) {
            return $jwtPayload['role'];
        }
        return null;
    }


    function getCurrentUserId() {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? '';
        $jwtPayload = validateJwt($authHeader);

        if ($jwtPayload && isset($jwtPayload['userId'])) {
            return (int) $jwtPayload['userId'];
        }
        return null;
    }
    
    function getCurrentUserFullName(){
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? '';
        $jwtPayload = validateJwt($authHeader);
        
        if ($jwtPayload && isset($jwtPayload['fullname'])) {
            return $jwtPayload['fullname'];
        }
        return null;
    }
    
    function getCurrentUserEmail(){
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? '';
        $jwtPayload = validateJwt($authHeader);
        
        if ($jwtPayload && isset($jwtPayload['email'])) {
            return $jwtPayload['email'];
        }
        return null;
    }

?>
