<?php

require_once __DIR__ . "/../vendor/dompdf/autoload.inc.php";

use Dompdf\Dompdf;
use Dompdf\Options;

class PdfGenerator {
    /**
     * Generates a comprehensive report PDF using Dompdf.
     *
     * @param array $reportData An associative array containing all report details.
     * @return string|false Path to the generated PDF file on success, false on failure.
     */
    public function generateReportPdf($reportData) {
        $options = new Options();
        $options->set('isRemoteEnabled', true); // Enable loading of remote (or local file://) images
        $dompdf = new Dompdf($options);
        
        $dompdf->setBasePath(__DIR__ . '/../');
        // --- ADD THESE DEBUGGING LINES HERE ---



        $html = $this->buildReportHtml($reportData);

        if (is_string($html) && strpos($html, '<h1>Error:') === 0) {
            error_log("HTML generation failed: " . $html);
            return false;
        }

        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');

        try {
            $dompdf->render();

            $outputDir = __DIR__ . '/../public/reports/';
            if (!is_dir($outputDir)) {
                mkdir($outputDir, 0777, true);
            }
            $filename = ($reportData['report_index'] ?? 'UNKNOWN') . ".pdf";
            $outputPath = $outputDir . $filename;

            // Save the PDF to a file
            $pdf = $dompdf->output();
            file_put_contents($outputPath, $pdf);
            return $outputPath; // Return the path to the saved file

        } catch (Exception $e) {
            error_log("Failed to generate PDF: " . $e->getMessage());
            return false;
        }
    }
    
    public function generateMaintenancePdf(array $data) {
        $options = new Options();
        $options->set('isRemoteEnabled', true); // Enable loading of remote (or local file://) images
        $dompdf = new Dompdf($options);
        
        $dompdf->setBasePath(__DIR__ . '/../');
        
        $html = $this->buildMaintenanceHtml($data);

        if (is_string($html) && strpos($html, '<h1>Error:') === 0) {
            error_log("HTML generation failed: " . $html);
            return false;
        }

        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');

        try {
            $dompdf->render();

            $outputDir = __DIR__ . '/../public/maintenance/';
            if (!is_dir($outputDir)) {
                mkdir($outputDir, 0777, true);
            }
            $filename = ($reportData['report_index'] ?? 'UNKNOWN') . ".pdf";
            $outputPath = $outputDir . $filename;

            // Save the PDF to a file
            $pdf = $dompdf->output();
            file_put_contents($outputPath, $pdf);
            return $outputPath; // Return the path to the saved file

        } catch (Exception $e) {
            error_log("Failed to generate PDF: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Builds the HTML content for the PDF report by including an external template.
     *
     * @param array $data The aggregated report data.
     * @return string The HTML string for the PDF.
     */
    private function buildReportHtml($data) {
        if (!is_array($data)) {
            error_log("buildReportHtml received non-array data: " . gettype($data));
            return "<h1>Error: Invalid data provided for PDF generation!</h1>";
        }

        ob_start();

        $templatePath = __DIR__ . "/../templates/pdftemplate.html";

        if (!file_exists($templatePath)) {
            error_log("PDF template not found: " . $templatePath);
            return "<h1>Error: PDF template not found!</h1>";
        }

        extract($data);

        include $templatePath;

        $html = ob_get_clean();

        return $html;
    }
    
    private function buildMaintenanceHtml($data) {
        if (!is_array($data)) {
            error_log("buildMaintenanceHtml received non-array data: " . gettype($data));
            return "<h1>Error: Invalid data provided for PDF generation!</h1>";
        }

        ob_start();

        $templatePath = __DIR__ . "/../templates/maintenance_pdftemplate.html";

        if (!file_exists($templatePath)) {
            error_log("PDF template not found: " . $templatePath);
            return "<h1>Error: PDF template not found!</h1>";
        }

        extract($data);

        include $templatePath;

        $html = ob_get_clean();

        return $html;
    }
}